/*
 * Decompiled with CFR 0.152.
 */
package cis.common.digsig.signer.ui;

import cis.common.digsig.DigitalSigningFactory;
import cis.common.digsig.certificate.AbstractKeyStoreManager;
import cis.common.digsig.certificate.KeyStoreContainerType;
import cis.common.digsig.signer.service.KeyStoreConfiguration;
import cis.common.digsig.signer.ui.CertificateExtractionFailureException;
import cis.common.digsig.signer.ui.CertificateListItem;
import cis.common.digsig.signer.ui.CertificateListModel;
import cis.common.digsig.signer.ui.Constants;
import cis.common.digsig.support.Base64Utils;
import cis.common.digsig.support.CertificationChainDetails;
import cis.common.digsig.support.KeyPairAndCertChain;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class CertificateSelectorController {
    private static final String X509_CERTIFICATE_TYPE = "X.509";
    private static final String CERTIFICATION_CHAIN_ENCODING = "PkiPath";
    protected static final String DIGITAL_SIGNATURE_ALGORITHM_NAME = "SHA1withRSA";
    private static Locale MK_LOCALE = new Locale("mk");
    private KeyStore windowsKeyStore;
    @Autowired
    private KeyStoreConfiguration configuration;

    public String loadPfxFileLocation() {
        if (this.configuration.getKeyStoreContainerType() != null && KeyStoreContainerType.PFX.equals((Object)this.configuration.getKeyStoreContainerType())) {
            return this.configuration.getKeystoreLocation();
        }
        return "";
    }

    public String loadSmartCardFileLocation() {
        if (this.configuration.getKeyStoreContainerType() != null && KeyStoreContainerType.SC.equals((Object)this.configuration.getKeyStoreContainerType())) {
            return this.configuration.getKeystoreLocation();
        }
        return "";
    }

    public String loadPfxPasscode() {
        if (this.configuration.getKeyStoreContainerType() != null && KeyStoreContainerType.PFX.equals((Object)this.configuration.getKeyStoreContainerType())) {
            return this.configuration.getKeyStorePasscode();
        }
        return "";
    }

    public String loadSmartCardPasscode() {
        if (this.configuration.getKeyStoreContainerType() != null && KeyStoreContainerType.SC.equals((Object)this.configuration.getKeyStoreContainerType())) {
            return this.configuration.getKeyStorePasscode();
        }
        return "";
    }

    public boolean isCertificateSelected() {
        return this.configuration.getKeyStoreContainerType() != null;
    }

    public KeyStoreContainerType loadKeyStoreType() {
        return this.configuration.getKeyStoreContainerType();
    }

    public String loadCertificateSubject() {
        return this.configuration.getCertificateSubject();
    }

    public String loadCertificateIssuer() {
        return this.configuration.getCertificateIssuer();
    }

    public String loadCertificateSerialnumber() {
        return this.configuration.getCertificateSerialNumber();
    }

    public String loadCertificateValidFrom() {
        return this.configuration.getCertificateValidFrom();
    }

    public String loadCertificateValidTo() {
        return this.configuration.getCertificateValidTo();
    }

    public void updateConfigurationProperties(String keyStoreContainerType, String keyStoreFileLocation, String keyStorePasscode, String keyStoreAlias) {
        this.configuration.setKeyStoreAlias(keyStoreAlias);
        this.configuration.setKeyStoreContainerType(keyStoreContainerType);
        this.configuration.setKeyStoreLocation(keyStoreFileLocation);
        this.configuration.setKeyStorePasscode(keyStorePasscode);
        this.configuration.saveApplicationProperties();
    }

    public void updateConfigurationProperties(String keyStoreContainerType, String keyStoreFileLocation, String keyStorePasscode, String keyStoreAlias, String subject, String issuer, String serialNumber, String validFrom, String validTo) {
        this.configuration.setKeyStoreAlias(keyStoreAlias);
        this.configuration.setKeyStoreContainerType(keyStoreContainerType);
        this.configuration.setKeyStoreLocation(keyStoreFileLocation);
        this.configuration.setKeyStorePasscode(keyStorePasscode);
        this.configuration.setCertificateIssuer(issuer);
        this.configuration.setCertificateSerialNumber(serialNumber);
        this.configuration.setCertificateSubject(subject);
        this.configuration.setCertificateValidFrom(validFrom);
        this.configuration.setCertificateValidTo(validTo);
        this.configuration.saveApplicationProperties();
    }

    public CertificateListModel addWindowsKeyStoreCertificatesToList() throws KeyStoreException {
        if (this.windowsKeyStore != null) {
            Enumeration<String> en = this.windowsKeyStore.aliases();
            ArrayList<CertificateListItem> listData = new ArrayList<CertificateListItem>();
            while (en.hasMoreElements()) {
                String aliasKey = en.nextElement();
                CertificateListItem ci = new CertificateListItem(aliasKey, this.windowsKeyStore.getCertificate(aliasKey));
                listData.add(ci);
            }
            CertificateListModel certListModel = new CertificateListModel();
            certListModel.setItems(listData);
            return certListModel;
        }
        return null;
    }

    public KeyStore loadKeyStoreFromWindowsPersonalKeystore() throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        if (this.windowsKeyStore == null) {
            this.windowsKeyStore = KeyStore.getInstance("Windows-MY");
            this.windowsKeyStore.load(null, null);
        }
        return this.windowsKeyStore;
    }

    public CertificationChainDetails runExtractor(KeyStoreContainerType strategy, String fileLocation, String passcode, CertificateListItem cli) throws CertificateExtractionFailureException, CertificateException {
        try {
            KeyPairAndCertChain privateKeyAndCertChain;
            if (strategy.equals((Object)KeyStoreContainerType.WKS)) {
                privateKeyAndCertChain = this.getPrivateKeyAndCertChainForWks(this.windowsKeyStore, passcode == null ? null : passcode.toCharArray(), cli);
            } else {
                AbstractKeyStoreManager am = DigitalSigningFactory.newKeyStoreLoader((KeyStoreContainerType)strategy, (String)fileLocation, (String)passcode, null);
                am.loadKeyStore();
                privateKeyAndCertChain = am.getPrivateKeyAndCertChain();
            }
            Certificate[] certChain = privateKeyAndCertChain.mCertificationChain;
            if (certChain == null) {
                String errorMessage = Constants.getMessage((String)"signer.certificate.extract.error");
                throw new CertificateExtractionFailureException(errorMessage);
            }
            CertificationChainDetails certificateDetails = new CertificationChainDetails();
            DateFormat dateFormatter = DateFormat.getDateInstance(2, MK_LOCALE);
            X509Certificate clientCert = (X509Certificate)certChain[0];
            certificateDetails.setSerialNumber(clientCert.getSerialNumber().toString());
            certificateDetails.setPublisher(clientCert.getIssuerX500Principal().getName());
            certificateDetails.setValidFrom(dateFormatter.format(clientCert.getNotBefore()));
            certificateDetails.setValidTo(dateFormatter.format(clientCert.getNotAfter()));
            certificateDetails.setSubject(clientCert.getSubjectDN().getName());
            try {
                certificateDetails.setEncodedCertificate(clientCert.getEncoded());
            }
            catch (CertificateEncodingException cee) {
                cee.printStackTrace();
                throw new CertificateExtractionFailureException((Throwable)cee);
            }
            try {
                certificateDetails.setCertificationChain(this.encodeX509CertChainToBase64(certChain));
            }
            catch (CertificateException cee) {
                cee.printStackTrace();
                String errorMessage = Constants.getMessage((String)"signer.certificate.invalid");
                throw new CertificateExtractionFailureException(errorMessage);
            }
            return certificateDetails;
        }
        catch (GeneralSecurityException ex) {
            ex.printStackTrace();
            throw new CertificateExtractionFailureException(Constants.getMessage((String)"signer.certificate.extract.error"));
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new CertificateExtractionFailureException(Constants.getMessage((String)"signer.certificate.extract.io.error"));
        }
    }

    private KeyPairAndCertChain getPrivateKeyAndCertChainForWks(KeyStore aKeyStore, char[] pass, CertificateListItem cli) throws GeneralSecurityException {
        Enumeration<String> aliasesEnum = aKeyStore.aliases();
        if (aliasesEnum.hasMoreElements()) {
            String alias = cli.getItemId();
            Certificate[] certificationChain = aKeyStore.getCertificateChain(alias);
            PrivateKey privateKey = (PrivateKey)aKeyStore.getKey(alias, pass);
            Certificate cert = aKeyStore.getCertificate(alias);
            PublicKey publicKey = cert.getPublicKey();
            KeyPairAndCertChain result = new KeyPairAndCertChain();
            result.mPrivateKey = privateKey;
            result.mPublicKey = publicKey;
            result.mCertificationChain = certificationChain;
            return result;
        }
        throw new KeyStoreException("The keystore is empty!");
    }

    protected String encodeX509CertChainToBase64(Certificate[] aCertificationChain) throws CertificateException {
        List<Certificate> certList = Arrays.asList(aCertificationChain);
        CertificateFactory certFactory = CertificateFactory.getInstance(X509_CERTIFICATE_TYPE);
        CertPath certPath = certFactory.generateCertPath(certList);
        byte[] certPathEncoded = certPath.getEncoded(CERTIFICATION_CHAIN_ENCODING);
        String base64encodedCertChain = Base64Utils.base64Encode((byte[])certPathEncoded);
        return base64encodedCertChain;
    }
}

